/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CProgressBar.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CProgressBar_h	// [
#define Included_CProgressBar_h

#include "pgpClassesConfig.h"

#include <commctrl.h>
#include "CWindow.h"

_PGP_BEGIN

// Class CProgressBar

class CProgressBar : public CWindow
{
public:
	CProgressBar() { }
	CProgressBar(HWND hWnd) : CWindow(hWnd) { }
	~CProgressBar() { }

	PGPInt32	DeltaPos(PGPUInt32 delta) const
	{
		return SendMessage(PBM_DELTAPOS, delta, 0);
	}

	PGPInt32	GetPos() const
	{
		return SendMessage(PBM_GETPOS, 0, 0);
	}

	void		GetRange(PGPInt32& low, PGPInt32& high) const;

	PGPInt32	SetPos(PGPInt32 newPos) const
	{
		return SendMessage(PBM_SETPOS, newPos, 0);
	}

	PGPInt32	SetPosWTimeout(PGPInt32 newPos, PGPUInt32 ms) const;

	PGPUInt32	SetRange(PGPInt32 low, PGPInt32 high)
	{
		return SendMessage(PBM_SETRANGE32, low, high);
	}

	PGPUInt32	SetStep(PGPUInt32 step) const
	{
		return SendMessage(PBM_SETSTEP, step, 0);
	}

	PGPUInt32	StepIt() const
	{
		return SendMessage(PBM_STEPIT, 0, 0);
	}

	PGPUInt32	StepItAsync() const
	{
		return PostMessage(PBM_STEPIT, 0, 0);
	}
};

_PGP_END

#endif	// ] Included_CProgressBar_h
